/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.IOException;
import java.io.InputStream;
import org.python.core.io.TextIOBase;

public class TextIOInputStream
extends InputStream {
    private TextIOBase textIO;

    public TextIOInputStream(TextIOBase textIOBase) {
        this.textIO = textIOBase;
    }

    public int read() throws IOException {
        String string = this.textIO.read(1);
        if (string.length() == 0) {
            return -1;
        }
        return string.charAt(0);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        String string = this.textIO.read(n2);
        n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)string.charAt(i);
        }
        return n2 == 0 ? -1 : n2;
    }

    public void close() throws IOException {
        this.textIO.close();
    }

    public long skip(long l) throws IOException {
        return this.textIO.seek(l, 1);
    }
}

